/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class TryHistory {
    public static void main(String[] args) throws FileNotFoundException, IOException, Exception {
        File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/bookmarks/history.txt");
        File fout = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/bookmarks/tryhistory.log");
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String s = reader.readLine();
        PrintStream out = new PrintStream(fout);
        int lineCount = 1;
        while (s != null) {
            ++lineCount;
            s = reader.readLine();
        }
        reader.close();
        reader = new BufferedReader(new FileReader(f));
        s = reader.readLine();
        LinkedHashMap<String, Integer> plottedURIs = new LinkedHashMap<String, Integer>();
        int i = 1;
        LinkedHashMap<String, ArrayList<String>> exceptions = new LinkedHashMap<String, ArrayList<String>>();
        long t00 = System.currentTimeMillis();
        Datum firstTime = null;
        Datum lastTime = null;
        while (s != null) {
            String[] ss = s.split("\t", 2);
            String time = ss[0];
            String suri = ss[1];
            if (firstTime == null) {
                firstTime = TimeUtil.createValid((String)time);
            }
            lastTime = TimeUtil.createValid((String)time);
            Integer count = (Integer)plottedURIs.get(suri);
            if (count == null || count == 0) {
                out.println("=== " + i + "/" + lineCount + " ===================================================");
                out.println("readat: " + time);
                out.println("uri:    " + suri);
                long t0 = System.currentTimeMillis();
                try {
                    QDataSet ds = Util.getDataSet((String)suri, (ProgressMonitor)new NullProgressMonitor());
                    out.println("result: " + ds);
                }
                catch (Exception ex) {
                    String exs = ex.getMessage();
                    if (exs == null) {
                        exs = ex.toString();
                    }
                    if (!exs.equals("Unsupported extension: vap")) {
                        out.println("exception: " + ex);
                        ArrayList<String> uris = (ArrayList<String>)exceptions.get(exs);
                        if (uris == null) {
                            uris = new ArrayList<String>();
                        }
                        uris.add(suri);
                        exceptions.put(exs, uris);
                    }
                    out.println("ignoring vap files for now");
                }
                out.println("readtm: " + String.format(Locale.US, "%9.2f", (double)(System.currentTimeMillis() - t0) / 1000.0).trim() + " sec");
                out.println("tottim: " + String.format(Locale.US, "%9.2f", (double)(System.currentTimeMillis() - t00) / 1000.0 / 60.0).trim() + " min");
                count = 1;
                plottedURIs.put(suri, count);
            } else {
                Integer t0 = count;
                Integer n = count = Integer.valueOf(count + 1);
                plottedURIs.put(suri, count);
            }
            ++i;
            s = reader.readLine();
        }
        reader.close();
        out.println("\n===== Summary =================================================");
        DatumRange dr = new DatumRange(TimeUtil.prevMidnight(firstTime), TimeUtil.nextMidnight(lastTime));
        out.println("interval of history: " + dr);
        double totSec = (double)(System.currentTimeMillis() - t00) / 1000.0;
        out.println("total time to read: " + String.format(Locale.US, "%9.2f", totSec / 60.0).trim() + " min");
        out.println("total URIs read: " + plottedURIs.size());
        out.println("URIs/sec: " + String.format(Locale.US, "%9.2f", 1.0 * (double)plottedURIs.size() / totSec));
        out.println("Exceptions encountered: " + exceptions.size());
        out.println("\n=== Exceptions ==============================================");
        for (Map.Entry en : exceptions.entrySet()) {
            List uris = (List)exceptions.get(en.getKey());
            out.println((String)en.getKey());
            for (String uri : uris) {
                out.println("  " + uri);
            }
            out.println("");
        }
    }
}

